<?php

function trizzy_form_system_theme_settings_alter(&$form, $form_state) {
  $path = drupal_get_path('theme', 'trizzy');
  drupal_add_library('system', 'ui');
  drupal_add_library('system', 'farbtastic');

  drupal_add_js($path . '/js/theme_admin.js');

  $form['settings'] = array(
      '#type' => 'vertical_tabs',
      '#title' => t('Theme settings'),
      '#weight' => 2,
      '#collapsible' => TRUE,
      '#collapsed' => FALSE,
  );

  $form['settings']['general'] = array(
      '#type' => 'fieldset',
      '#title' => t('General settings'),
      '#collapsible' => TRUE,
      '#collapsed' => FALSE,
  );
  $form['settings']['general']['theme_layout_style'] = array(
      '#type' => 'select',
      '#title' => t('Layout'),
      '#options' => array(
          'boxed' => t('Boxed'),
          'full-width' => t('Full width'),
      ),
      '#default_value' => theme_get_setting('theme_layout_style'),
  );
  $form['settings']['general']['theme_menu_style'] = array(
      '#type' => 'select',
      '#title' => t('Main menu style'),
      '#options' => array(
          'dark' => t('Dark'),
          'light' => t('Light'),
      ),
      '#default_value' => theme_get_setting('theme_menu_style'),
  );

  $form['settings']['general']['theme_google_font'] = array(
      '#type' => 'textfield',
      '#title' => t('Google font URL'),
      '#default_value' => theme_get_setting('theme_google_font'),
      '#description' => t('Get your google font availabe <a href="!url">here</a>', array('!url' => 'http://www.google.com/fonts')),
  );
  $form['settings']['general']['custom_theme_css'] = array(
      '#type' => 'textarea',
      '#title' => t('Custom theme css'),
      '#default_value' => theme_get_setting('custom_theme_css'),
      '#description' => t('Custom your own css, eg: <strong>#social-footer {background-color:#F5F5F5;}</strong>'),
  );
  $form['settings']['general']['theme_color'] = array(
      '#title' => t('Theme color'),
      '#type' => 'textfield',
      '#default_value' => theme_get_setting('theme_color'),
      '#attributes' => array('class' => array('input color')),
      '#description' => t('This is main color of the theme. Default color hex code is: <a style="color:#3acf87" class="color-default" href="javascript:void(0); ">#3acf87</a>'),
  );

  $form['settings']['general']['theme_background_color'] = array(
      '#title' => t('Background color'),
      '#type' => 'textfield',
      '#default_value' => theme_get_setting('theme_background_color'),
      '#attributes' => array('class' => array('input color')),
      '#description' => t('Background color only for boxed layout. Default color hex code is: <a style="color:#e9e9e9" class="color-default" href="javascript:void(0); ">#e9e9e9</a>'),
  );
  // bg background
  $dir = drupal_get_path('theme', 'trizzy') . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'bg';

  $files = file_scan_directory($dir, '/.*\.png/');


  $bg_files = array('' => t('No background image'));
  if (!empty($files)) {
    foreach ($files as $file) {
      if (isset($file->filename)) {
        $bg_files[$file->filename] = $file->filename;
      }
    }
  }
  $form['settings']['general']['theme_background_image'] = array(
      '#title' => t('Background image'),
      '#type' => 'select',
      '#default_value' => theme_get_setting('theme_background_image'),
      '#options' => $bg_files,
      '#description' => t('Background image only for boxed layout. All images background in <strong>!url</strong>', array('!url' => $dir)),
  );
  $form['settings']['advance'] = array(
      '#type' => 'fieldset',
      '#title' => t('Advance settings'),
      '#collapsible' => TRUE,
      '#collapsed' => FALSE,
  );
  $form['settings']['advance']['use_theme_switcher'] = array(
      '#title' => t('Use theme switcher'),
      '#type' => 'checkbox',
      '#default_value' => theme_get_setting('use_theme_switcher'),
      '#description' => t('Enable style , color, background swicher.'),
  );
}
